ScriptName RaceMenuMorphsCBBE Extends RaceMenuBase

; Version data
Int Property NIOVERRIDE_VERSION = 6 AutoReadOnly
Int Property NIOVERRIDE_SCRIPT_VERSION = 6 AutoReadOnly
Int Property RM_CBBE_VERSION = 2 AutoReadOnly
Int Property Version = 0 Auto

String Property CALLBACK_PART = "ChangePart" AutoReadOnly

String Property CATEGORY_KEY = "rsm_bodymorph_cbbe" AutoReadOnly
String Property MORPH_KEY = "RaceMenuMorphsCBBE.esp" AutoReadOnly

String[] morphs

Event OnInit()
	Parent.OnInit()
	Version = RM_CBBE_VERSION
EndEvent

Bool Function CheckNiOverride()
	Return SKSE.GetPluginVersion("NiOverride") >= NIOVERRIDE_VERSION && NiOverride.GetScriptVersion() >= NIOVERRIDE_SCRIPT_VERSION
EndFunction

Function InitMorphNames()
	morphs = new String[53]
	morphs[0] = "Breasts"
	morphs[1] = "BreastsSmall"
	morphs[2] = "BreastsSH"
	morphs[3] = "BreastsSSH"
	morphs[4] = "BreastsFantasy"
	morphs[5] = "DoubleMelon"
	morphs[6] = "BreastCleavage"
	morphs[7] = "BreastFlatness"
	morphs[8] = "BreastGravity"
	morphs[9] = "PushUp"
	morphs[10] = "BreastHeight"
	morphs[11] = "BreastPerkiness"
	morphs[12] = "BreastWidth"		
	morphs[13] = "NippleDistance"
	morphs[14] = "NipplePerkiness"
	morphs[15] = "NippleLength"
	morphs[16] = "NippleSize"
	morphs[17] = "NippleAreola"
	morphs[18] = "NippleUp"
	morphs[19] = "NippleDown"
	morphs[20] = "NippleTip"
	morphs[21] = "BigTorso"
	morphs[22] = "Waist"
	morphs[23] = "WideWaistLine"
	morphs[24] = "ChubbyWaist"
	morphs[25] = "Back"
	morphs[26] = "ButtCrack"		
	morphs[27] = "Butt"
	morphs[28] = "ButtSmall"		
	morphs[29] = "ButtShape2"
	morphs[30] = "BigButt"
	morphs[31] = "ChubbyButt"
	morphs[32] = "AppleCheeks"
	morphs[33] = "RoundAss"
	morphs[34] = "Groin"
	morphs[35] = "Hipbone"
	morphs[36] = "Hips"
	morphs[37] = "SlimThighs"
	morphs[38] = "Thighs"
	morphs[39] = "ChubbyLegs"
	morphs[40] = "Legs"
	morphs[41] = "KneeHeight"
	morphs[42] = "CalfSize"
	morphs[43] = "CalfSmooth"
	morphs[44] = "Ankles"
	morphs[45] = "Arms"
	morphs[46] = "ChubbyArms"
	morphs[47] = "ShoulderSmooth"
	morphs[48] = "ShoulderWidth"
	morphs[49] = "Belly"
	morphs[50] = "BigBelly"
	morphs[51] = "PregnancyBelly"
	morphs[52] = "TummyTuck"
EndFunction

Event OnCategoryRequest()
	AddCategory(CATEGORY_KEY, "CBBE MORPHS", -948)
	InitMorphNames()
EndEvent

;Add custom sliders here
Event OnSliderRequest(Actor player, ActorBase playerBase, Race actorRace, Bool isFemale)
	If isFemale && CheckNiOverride()
		Float factor = 2.0
		Int m
		While m < morphs.Length
			; Version Update
			If Version <= 0
				Float oldValue = NiOverride.GetMorphValue(_targetActor, morphs[m])
				If oldValue != 0.0
					NiOverride.SetBodyMorph(_targetActor, morphs[m], MORPH_KEY, oldValue)
				EndIf
				NiOverride.ClearMorphValue(_targetActor, morphs[m])
			EndIf
			
			; Sliders
			AddSliderEx(morphs[m], CATEGORY_KEY, CALLBACK_PART + morphs[m], -factor, factor, 0.01, getBodyMorph(_targetActor, morphs[m]))
			m += 1
		EndWhile
		
		Version = RM_CBBE_VERSION
	Endif
EndEvent

Event OnSliderChanged(String callback, Float value)
	If CheckNiOverride()
		Int m
		While m < morphs.Length
			If callback == (CALLBACK_PART + morphs[m])
				addBodyMorph(_targetActor, morphs[m], value)
			EndIf
			m += 1
		EndWhile
	Endif
EndEvent

Function addBodyMorph(ObjectReference ref, String baseMorphName, Float value)
	NiOverride.SetBodyMorph(ref, baseMorphName, MORPH_KEY, value)
	NiOverride.UpdateModelWeight(ref)
EndFunction

Float Function getBodyMorph(ObjectReference ref, String baseMorphName)
	Return NiOverride.GetBodyMorph(ref, baseMorphName, MORPH_KEY)
EndFunction
